/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.HSCCECClient;
import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.client.HSCFrameClient;
import com.ibm.hsc.client.HSCLPARClient;
import com.ibm.hsc.command.ControllerThread;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommands;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.HscConstants;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class RemoveSystemConfiguration
implements HMCCommands {
    private static final char GOOD_STATUS = '\u0000';
    private static final char ERROR_STATUS = '\u0001';
    private static final String AFFINITY_PARTITION_TYPE = HMCCommandUtils.AFFINITY_PARTITION_TYPE;
    private static final String PARTITION_TYPE = HMCCommandUtils.PARTITION_TYPE;
    private static final String PROFILE_TYPE = HMCCommandUtils.PROFILE_TYPE;
    private static final String SYSTEM_TYPE = HMCCommandUtils.SYSTEM_TYPE;
    private static final String SYSTEM_PROFILE_TYPE = HMCCommandUtils.SYSTEM_PROFILE_TYPE;
    private HSCCECClient hcc = null;
    private HSCFrameClient hfc = null;
    private HSCLPARClient hlc = null;
    private String frameName;
    private String name;
    private String partitionName;
    private String managedSystem;
    private String type;
    private boolean writeStatus;
    private PrintStream output;

    public RemoveSystemConfiguration(boolean bl) {
        if (bl) {
            this.writeStatus = false;
            this.output = System.out;
        } else {
            this.writeStatus = true;
            this.output = ((ControllerThread)Thread.currentThread()).getOutputStream();
        }
    }

    private void initializeClients() throws HSCException {
        HSCClientObjectFactory hSCClientObjectFactory = null;
        InetAddress inetAddress = null;
        String string = null;
        String string2 = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            throw new HSCException(exception);
        }
        hSCClientObjectFactory = HSCClientObjectFactory.getInstance(string2, null);
        if (this.type.equals(HMCCommandUtils.PARTITION_TYPE) || this.type.equals(HMCCommandUtils.AFFINITY_PARTITION_TYPE) || this.type.equals(HMCCommandUtils.SYSTEM_PROFILE_TYPE)) {
            this.hcc = hSCClientObjectFactory.createCECClient(this.managedSystem, false);
            if (null == this.hcc) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
                throw new HSCException(string);
            }
        } else if (this.type.equals(HMCCommandUtils.SYSTEM_TYPE)) {
            this.hfc = hSCClientObjectFactory.createFrameClient(this.frameName);
        } else if (this.type.equals(HMCCommandUtils.PROFILE_TYPE)) {
            this.hcc = hSCClientObjectFactory.createCECClient(this.managedSystem, false);
            if (null == this.hcc) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
                throw new HSCException(string);
            }
            this.hlc = hSCClientObjectFactory.createLPARClient(this.managedSystem, this.partitionName, false);
            if (null == this.hlc) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PARTITION_NOT_FOUND");
                throw new HSCException(string);
            }
        }
    }

    private void checkRequiredParameters() throws RequiredParameterException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (null == this.type && null == this.name) {
            objectArray = new String[]{HMCCommandUtils.RESOURCE_TYPE_PARAM};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.type != null && this.type.equals(HMCCommandUtils.AFFINITY_PARTITION_TYPE) && null == this.managedSystem) {
            objectArray = new String[]{HMCCommandUtils.RESOURCE_TYPE_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.MANAGED_SYSTEM_PARAM};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.RESOURCE_TYPE_PARAM + " and " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.type != null && (this.type.equals(HMCCommandUtils.PARTITION_TYPE) || this.type.equals(HMCCommandUtils.SYSTEM_PROFILE_TYPE)) && null == this.managedSystem) {
            objectArray = new String[]{HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.NAME_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.MANAGED_SYSTEM_PARAM};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.NAME_PARAM + ", and" + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.type != null && this.type.equals(HMCCommandUtils.SYSTEM_TYPE) && null == this.name) {
            objectArray = new String[]{HMCCommandUtils.RESOURCE_TYPE_PARAM + " and " + HMCCommandUtils.NAME_PARAM};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.RESOURCE_TYPE_PARAM + " and " + HMCCommandUtils.NAME_PARAM + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.type != null && this.type.equals(HMCCommandUtils.PROFILE_TYPE) && (null == this.managedSystem || null == this.partitionName)) {
            objectArray = new String[]{HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.NAME_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.NAME_PARAM + ", and" + HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
    }

    private void validateParameterValues() throws RequiredParameterException, HSCException {
        Hashtable hashtable = null;
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        short s = 0;
        short s2 = 0;
        if (!(this.type == null || this.type.equals(HMCCommandUtils.SYSTEM_TYPE) || this.type.equals(HMCCommandUtils.AFFINITY_PARTITION_TYPE) || this.type.equals(HMCCommandUtils.PARTITION_TYPE) || this.type.equals(HMCCommandUtils.PROFILE_TYPE) || this.type.equals(HMCCommandUtils.SYSTEM_PROFILE_TYPE))) {
            objectArray = new String[]{HMCCommandUtils.PARTITION_TYPE + ", " + HMCCommandUtils.AFFINITY_PARTITION_TYPE + ", " + HMCCommandUtils.PROFILE_TYPE + ", " + HMCCommandUtils.SYSTEM_PROFILE_TYPE + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR", "or", null) + " " + HMCCommandUtils.SYSTEM_TYPE};
            string = "An invalid parameter value was entered. The object type entered must be" + HMCCommandUtils.PARTITION_TYPE + ", " + HMCCommandUtils.AFFINITY_PARTITION_TYPE + ", " + HMCCommandUtils.PROFILE_TYPE + ", " + HMCCommandUtils.SYSTEM_PROFILE_TYPE + ", or " + HMCCommandUtils.SYSTEM_TYPE + ". Please retry command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "INVALID_OBJECT_TYPE_VALUE", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.type.equals(AFFINITY_PARTITION_TYPE) || this.type.equals(PARTITION_TYPE) || this.type.equals(PROFILE_TYPE)) {
            hashtable = this.hcc.getSystemData();
            s = ((Integer)hashtable.get("State")).shortValue();
            s2 = ((Integer)hashtable.get("Mode")).shortValue();
            if (s == 3 || s == 6 || s == 251 || s2 == HscConstants.SMP_MODE.shortValue()) {
                string = "The resource cannot be removed because the managed system is in initializing state, no power state, recovery state, or SMP mode. Please retry command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_CANNOT_PERFORM_REMOVE_CEC_STATE", string, objectArray);
                throw new RequiredParameterException(string2);
            }
        }
    }

    public void performCommand() throws HSCException, RequiredParameterException {
        this.checkRequiredParameters();
        this.initializeClients();
        this.validateParameterValues();
        if (this.type.equals(HMCCommandUtils.PARTITION_TYPE)) {
            this.hcc.deletePartition(this.name);
        } else if (this.type.equals(HMCCommandUtils.AFFINITY_PARTITION_TYPE)) {
            this.hcc.deleteAffinityPartitions();
        } else if (this.type.equals(HMCCommandUtils.PROFILE_TYPE)) {
            this.hlc.deleteProfile(this.name);
        } else if (this.type.equals(HMCCommandUtils.SYSTEM_PROFILE_TYPE)) {
            this.hcc.deleteProfile(this.name);
        } else if (this.type.equals(HMCCommandUtils.SYSTEM_TYPE)) {
            this.hfc.deleteCEC(this.name);
        }
    }

    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        Object var2_2 = null;
        this.frameName = (String)hashMap.get(HMCCommandUtils.FRAME_NAME_PARAM);
        this.managedSystem = (String)hashMap.get(HMCCommandUtils.MANAGED_SYSTEM_PARAM);
        this.name = (String)hashMap.get(HMCCommandUtils.NAME_PARAM);
        this.partitionName = (String)hashMap.get(HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM);
        this.type = (String)hashMap.get(HMCCommandUtils.RESOURCE_TYPE_PARAM);
    }

    public void printResults() {
    }

    public void printHelp() {
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "REMOVE_SYSTEM_CONFIGURATION_HELP"));
    }

    public static void main(String[] stringArray) {
        RemoveSystemConfiguration removeSystemConfiguration = new RemoveSystemConfiguration(true);
        int n = removeSystemConfiguration.process(stringArray);
        System.exit(n);
    }

    public static void entryMethod(String[] stringArray) {
        RemoveSystemConfiguration removeSystemConfiguration = new RemoveSystemConfiguration(false);
        removeSystemConfiguration.process(stringArray);
    }

    private int process(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                this.printHelp();
            }
            int n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n];
                arrayList.add(string2);
                if (string2.equals(HMCCommandUtils.HELP_PARAM)) {
                    this.printHelp();
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                this.mapParameters(hashMap);
                this.performCommand();
            }
        }
        catch (HSCException hSCException) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            hSCException.printStackTrace(this.output);
            string = hSCException.getMessage();
            if (string == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            this.output.println(string);
            return 1;
        }
        catch (RequiredParameterException requiredParameterException) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            requiredParameterException.printStackTrace(this.output);
            string = requiredParameterException.getMessage();
            if (string == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            this.output.println(string);
            return 1;
        }
        catch (Exception exception) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            exception.printStackTrace(this.output);
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR"));
            return 1;
        }
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        return 0;
    }
}

